;==========================================================================
;Version history:
;==========================================================================
;2010/12/24     First edition
;2011/01/19     Optimize the service routine of software PWM
;               Add 32-level duty for software PWM
;==========================================================================
        .DATA
R_DutyCounter:          .DS     1
R_Index:                .DS     2
;==========================================================================
        .CODE
D_SoftPWMFreq:          .EQU    60      ;PWM frequency (Unit: Hz)
D_SoftPWMLevel:         .EQU    64      ;PWM level selection (32/64/128)
D_IO_EventNum:          .EQU    3       ;I/O number for IO_Event
;==========================================================================
;Definition of I/O event; user can modify to select the sequence of I/O event
;==========================================================================
T_IO_Event:
        .DW     D_IOB0          ;I/O number = 1 (Mapped to the number of Edit Event on G+ Eventor)
        .DW     D_IOB1          ;I/O number = 2
        .DW     D_IOB2          ;I/O number = 3
        .DW     D_IOB3          ;I/O number = 4
        .DW     D_IOB4          ;I/O number = 5
        .DW     D_IOB5          ;I/O number = 6
        .DW     D_IOB6          ;I/O number = 7
        .DW     D_IOB7          ;I/O number = 8

        .DW     D_IOD0          ;I/O number = 9 (Mapped to the number of Edit Event on G+ Eventor)
        .DW     D_IOD1          ;I/O number = 10
        .DW     D_IOD2          ;I/O number = 11
        .DW     D_IOD3          ;I/O number = 12
        .DW     D_IOD4          ;I/O number = 13
        .DW     D_IOD5          ;I/O number = 14
        .DW     D_IOD6          ;I/O number = 15
        .DW     D_IOD7          ;I/O number = 16

        .DW     D_IOA0          ;I/O number = 17 (Mapped to the number of Edit Event on G+ Eventor)
        .DW     D_IOA1          ;I/O number = 18
        .DW     D_IOA2          ;I/O number = 19
        .DW     D_IOA3          ;I/O number = 20
        .DW     D_IOA4          ;I/O number = 21
        .DW     D_IOA5          ;I/O number = 22
        .DW     D_IOA6          ;I/O number = 23
        .DW     D_IOA7          ;I/O number = 24

        .DW     D_IOC0          ;I/O number = 25 (Mapped to the number of Edit Event on G+ Eventor)
        .DW     D_IOC1          ;I/O number = 26
        .DW     D_IOC2          ;I/O number = 27
        .DW     D_IOC3          ;I/O number = 28
        .DW     D_IOC4          ;I/O number = 29
        .DW     D_IOC5          ;I/O number = 30
        .DW     D_IOC6          ;I/O number = 31
        .DW     D_IOC7          ;I/O number = 32
;==========================================================================
%SW_PWM_RAM_Define:     .MACRO  Count
        .IFZ    Count
            .IFCLEAR
            .MACEXIT
        .ENDIF

        .PAGE0
R_Duty|<Order>:         .DS     1       ;Bit7: SW_PWM control, 0 = Enable; 1 = Disable

Order:  .VAR    Order+1
        %SW_PWM_RAM_Define      Count-1
                        .ENDM
;==========================================================================
Order:  .VAR    0
        %SW_PWM_RAM_Define      D_IO_EventNum
;==========================================================================
%SW_PWM_InitDuty:       .MACRO  Count
        .IFZ    Count
            .IFCLEAR
            .MACEXIT
        .ENDIF

        LDA     #D_Bit7                 ;Disable
        STA     R_Duty|<Order>

Order:  .VAR    Order+1
        %SW_PWM_InitDuty        Count-1
                        .ENDM
;==========================================================================
%SW_PWM_Disable:        .MACRO  Pin
        LDA     R_Duty|<Pin>
        ORA     #D_Bit7
        STA     R_Duty|<Pin>
                        .ENDM
;==========================================================================
%SW_PWM_Enable:         .MACRO  Pin
        LDA     R_Duty|<Pin>
        AND     #~D_Bit7
        STA     R_Duty|<Pin>
                        .ENDM
;==========================================================================
%SW_PWM_SetDuty:        .MACRO  Pin
        .IF D_SoftPWMLevel = 128
        LSR     A
        .ENDIF
        .IF D_SoftPWMLevel = 64
        LSR     A
        LSR     A
        .ENDIF
        .IF D_SoftPWMLevel = 32
        LSR     A
        LSR     A
        LSR     A
        .ENDIF
        STA     R_Duty|<Pin>
                        .ENDM
;==========================================================================
%SW_PWM_Stop:           .MACRO  Count
        .IFZ    Count
            .IFCLEAR
            .MACEXIT
        .ENDIF

        %SW_PWM_Disable Order

        LDY     T_IO_Event+1,X
        LDA     T_IO_Event,X
        EOR     #FFH
        AND     P_PortBuf,Y
        STA     P_PortBuf,Y
        LDA     T_IO_Event,X
        ORA     P_PortDir,Y
        STA     P_PortDir,Y
        INX
        INX

Order:  .VAR    Order+1
        %SW_PWM_Stop    Count-1
                        .ENDM
;==========================================================================
%Gen_SW_PWM_Process:    .MACRO  Count
        .IFZ    Count
            .IFCLEAR
            .MACEXIT
        .ENDIF

        LDA     R_Duty|<Order>
        BMI     L_NextPWM#              ;Check if the designated I/O of SW PWM is disabled
        CMP     R_DutyCounter
        BEQ     L_PWM_Low#
        BCC     L_PWM_Low#
L_PWM_High#:                            ;IF Duty > Counter, set high
        LDY     T_IO_Event+1,X
        LDA     P_PortBuf,Y
        ORA     T_IO_Event,X
        STA     P_PortBuf,Y
        JMP     L_NextPWM#
L_PWM_Low#:                             ;IF Duty < or = Counter, set low
        LDY     T_IO_Event+1,X
        LDA     T_IO_Event,X
        EOR     #FFH
        AND     P_PortBuf,Y
        STA     P_PortBuf,Y
L_NextPWM#:
        INX
        INX

Order:  .VAR    Order+1
        %Gen_SW_PWM_Process     Count-1
                        .ENDM
;==========================================================================
%SW_PWM_Process:        .MACRO  Count
        INC     R_DutyCounter           ;Duty counter + 1
        LDA     R_DutyCounter
        CMP     #D_SoftPWMLevel
        BCC     L_Process#?
        STX     R_DutyCounter           ;Reset counter
L_Process#?:

Order:  .VAR    0
        %Gen_SW_PWM_Process     Count
                        .ENDM
;==========================================================================
%SW_PWMIO_Initial:      .MACRO  Count
        .IFZ    Count
            .IFCLEAR
            .MACEXIT
        .ENDIF

        LDY     T_IO_Event+1,X
        LDA     T_IO_Event,X
        EOR     #FFH
        AND     P_PortBuf,Y
        STA     P_PortBuf,Y
        LDA     T_IO_Event,X
        ORA     P_PortDir,Y
        STA     P_PortDir,Y
        INX
        INX

        %SW_PWMIO_Initial       Count-1
                        .ENDM
;==========================================================================
;Below table is used for I/O event, Don't modify
;==========================================================================
P_PortData:     .EQU    300H
P_PortBuf:      .EQU    301H
P_PortDir:      .EQU    302H
P_PortAtt:      .EQU    303H

D_IOA0:         .EQU    0001H
D_IOA1:         .EQU    0002H
D_IOA2:         .EQU    0004H
D_IOA3:         .EQU    0008H
D_IOA4:         .EQU    0010H
D_IOA5:         .EQU    0020H
D_IOA6:         .EQU    0040H
D_IOA7:         .EQU    0080H

D_IOB0:         .EQU    0401H
D_IOB1:         .EQU    0402H
D_IOB2:         .EQU    0404H
D_IOB3:         .EQU    0408H
D_IOB4:         .EQU    0410H
D_IOB5:         .EQU    0420H
D_IOB6:         .EQU    0440H
D_IOB7:         .EQU    0480H

D_IOC0:         .EQU    0801H
D_IOC1:         .EQU    0802H
D_IOC2:         .EQU    0804H
D_IOC3:         .EQU    0808H
D_IOC4:         .EQU    0810H
D_IOC5:         .EQU    0820H
D_IOC6:         .EQU    0840H
D_IOC7:         .EQU    0880H

D_IOD0:         .EQU    0C01H
D_IOD1:         .EQU    0C02H
D_IOD2:         .EQU    0C04H
D_IOD3:         .EQU    0C08H
D_IOD4:         .EQU    0C10H
D_IOD5:         .EQU    0C20H
D_IOD6:         .EQU    0C40H
D_IOD7:         .EQU    0C80H
;==========================================================================
